﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Newtonsoft.Json;

namespace TryReact.Controllers
{
    public class ReactCRUDController : Controller
    {

        #region Model

        public class DataEntity
        {
            public enum state
            {
                NoChange,
                Create,
                Update,
                Remove
            }

            public int ID { set; get; }
            public string Name { set; get; }
            public state State { set; get; }
        }

        static int _ID = -1;
        static int GetNextID { get { _ID++; return _ID; } }

        static List<DataEntity> DataStore = new List<DataEntity>()
        {
            new DataEntity(){ID = GetNextID, Name = "Elem0" },
            new DataEntity(){ID = GetNextID, Name = "Elem1" },
            new DataEntity(){ID = GetNextID, Name = "Elem2" },
            new DataEntity(){ID = GetNextID, Name = "Elem3" },
            new DataEntity(){ID = GetNextID, Name = "Elem4" },
        };

        #endregion


        // GET: ReactCRUD
        public ActionResult Index()
        {
            return View(DataStore);
        }


        #region API

        [HttpGet]
        public JsonResult List()
        {
            return Json(DataStore, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult SaveChange(string json)
        {
            var model = JsonConvert.
                DeserializeObject<IEnumerable<DataEntity>>(json);

            var store = DataStore;

            foreach (var elem in model)
            {
                DataEntity date_elem = null;

                switch (elem.State)
                {
                    case DataEntity.state.Create:
                        DataStore.Add(new DataEntity()
                        {
                            ID = GetNextID,
                            Name = elem.Name
                        });
                        break;
                    case DataEntity.state.Update:
                        date_elem = DataStore.FirstOrDefault(e => e.ID == elem.ID);
                        if (date_elem != null)
                            date_elem.Name = elem.Name;
                        break;
                    case DataEntity.state.Remove:
                        date_elem = DataStore.FirstOrDefault(e => e.ID == elem.ID);
                        if (date_elem != null)
                            DataStore.Remove(date_elem);
                        break;
                    //default:
                    //    date_elem = DataStore.FirstOrDefault(e => e.ID == elem.ID);
                    //    if (date_elem != null)
                    //        date_elem.Name = elem.Name;
                    //    break;
                }
            }

            return Json(true, JsonRequestBehavior.AllowGet);
        }



        //public void Create()
        //{
        //    DataStore.Add(new DataEntity()
        //    {
        //        ID = GetNextID
        //    });
        //}
        //public JsonResult Read()
        //{
        //    return Json(DataStore);
        //}
        //public void Update(int ID, string Name)
        //{
        //    DataStore.
        //        FirstOrDefault(e => e.ID == ID).Name = Name;
        //}
        //public void Delete(int ID)
        //{
        //    DataStore.Remove(DataStore.
        //        FirstOrDefault(e => e.ID == ID));
        //}

        #endregion

    }
}