﻿

class ReactAppPage extends React.Component {

    constructor(props) {
        super(props);
        this.api = new API_TextRecognising();
        this.state =
            {
                TextRecognising_Result: "",
                TextRecognising_Learn: "",
                sliderValue: 1,
                inputURL: ""
            };

        this.api = new API_TextRecognising();

        //@* Прикрепление текущего объекта к this в функции обработки *@
        this._OnClick_Button_Clear = this._OnClick_Button_Clear.bind(this);
        this._OnClick_Button_Recognized = this._OnClick_Button_Recognized.bind(this);
        this._OnClick_Button_Learn = this._OnClick_Button_Learn.bind(this);
        this.handleInputChange = this.handleInputChange.bind(this);
        this.handleInputURLChange = this.handleInputURLChange.bind(this);
        this.handleSliderChange = this.handleSliderChange.bind(this);
    }

    componentDidMount() {
        this.canvas = new Canvas(this.refs.CanvasElem);
        this.canvas.Set_UserWrite(true);
        this.canvas.PrintLine();
    }

    handleInputURLChange(event) {
        this.setState({ inputURL: event.target.value });
        this.canvas.DrawImage(this.state.inputURL);
    }

    handleInputChange(event) {
        this.setState({ TextRecognising_Learn: event.target.value });
    }

    handleSliderChange(event) {
        this.setState({ sliderValue: event.target.value });
        this.canvas.ChangeThickness(event.target.value);
    }

    _OnClick_Button_Clear() {
        this.canvas.ClearCanvas();
        this.setState({ TextRecognising_Result: "", TextRecognising_Learn: "" });
    }

    _OnClick_Button_Recognized() {
        let image = this.canvas.GetImage();

        this.api.Request_TextRecognising(image)
            .then((data) => {
                this.setState({ TextRecognising_Result: data.Result });
            });
    }

    _OnClick_Button_Learn() {
        let image = this.canvas.GetImage();

        this.api.Request_TextRecognising_Learn(image, this.state.TextRecognising_Learn)
            .then((data) => {
                this.setState({ TextRecognising_Result: data.Result });
            });
    }

    render() {
        return (
            <div>
                <div className="CanvasContainer">
                    <canvas ref={"CanvasElem"} width="500" height="300" />
                </div>

                <button
                    type="button"
                    onClick={this._OnClick_Button_Clear}
                    className="btn btn-secondary">
                    Очистить
                </button>
                <button
                    type="button"
                    onClick={this._OnClick_Button_Recognized}
                    className="btn btn-secondary">
                    Распознать
                </button>

                <div className="input-group mb-3">
                    <div className="input-group-prepend">
                        <span className="input-group-text" id="basic-addon1">Ссылка на изображение:</span>
                    </div>
                    <input type="text" value={this.state.inputURL} className="form-control" onChange={this.handleInputURLChange} />
                </div>

                <div className="input-group mb-3">
                    <div className="input-group-prepend">
                        <span className="input-group-text" id="basic-addon1">Result:</span>
                    </div>
                    <input type="text" readOnly="readonly" value={this.state.TextRecognising_Result} className="form-control" aria-describedby="basic-addon1" />
                </div>

                <div className="input-group mb-3">
                    <div className="input-group-prepend">
                        <button
                            type="button"
                            onClick={this._OnClick_Button_Learn}
                            className="btn btn-secondary">
                            Обучить
                        </button>
                    </div>
                    <input type="text" value={this.state.TextRecognising_Learn} className="form-control" onChange={this.handleInputChange} />
                </div>

                <div className="slidecontainer">
                    <input type="range" min="1" max="10" step="0.5" value={this.state.sliderValue} className="slider" onChange={this.handleSliderChange} />
                </div>
            </div>
        );
    }
}

// рендеринг элемента
ReactDOM.render(
    <ReactAppPage />,
    document.getElementById("app")
)
