using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

using System.IO;

using AppTools;

namespace NeuralNetwork.UI.Web
{
    public class MvcApplication : System.Web.HttpApplication
    {

        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);

            AddBinToPathVar();
            TestNetworkRun();
            GCClear();
        }


        private void TestNetworkRun() 
        {
            string path_App_Data = Server.MapPath("~/App_Data");
            string path_DataSet = Path.Combine(path_App_Data, "train.csv");

            NeuralNetwork.Model.Neutral.CNTK.MNIST.Init(path_DataSet);
        }

        private void AddBinToPathVar()
        {
            string path_bin = Server.MapPath("~/bin");

            PathProvider pp = new PathProvider();
            pp.AddIfNot(path_bin, EnvironmentVariableTarget.Process);
        }

        private void GCClear()
        {
            GC.Collect();
        }

    }
}
