﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NeuralNetwork.Model.Services
{
    /// <summary>
    /// Интерфейс для сервиса распознования
    /// </summary>
    public interface ITextRecognisingService
    {
        /// <summary>
        /// Основной метод распознования
        /// </summary>
        /// <param name="image">картинка</param>
        /// <returns></returns>
        int Work(byte[] image);

        /// <summary>
        /// Вспомогательный метод, проверка открытия файла как картинки
        /// </summary>
        /// <param name="image"></param>
        /// <returns></returns>
        bool TryOpen(byte[] image);
    }
}
