﻿

class ReactAppPage extends React.Component {

    constructor(props) {
        super(props);
        this.api = new API_TextRecognising();
        this.state =
        {
            TextRecognising_Result: ""
        };

        this.api = new API_TextRecognising();

        //@* Прикрепление текущего объекта к this в функции обработки *@
        this._OnClick_Button_Clear = this._OnClick_Button_Clear.bind(this);
        this._OnClick_Button_Recognized = this._OnClick_Button_Recognized.bind(this);
    }

    componentDidMount() {
        this.canvas = new Canvas(this.refs.CanvasElem);
        this.canvas.Set_UserWrite(true);
        this.canvas.PrintLine();
    }

    _OnClick_Button_Clear() {
        this.canvas.ClearCanvas();
    }

    _OnClick_Button_Recognized() {
        let image = this.canvas.GetImage();

        this.api.Request_TextRecognising(image)
            .then((data) => {
                this.setState({ TextRecognising_Result: data.Result });
            });
    }

    render() {
        return (
            <div>
                <div className="CanvasContainer">
                    <canvas ref={"CanvasElem"} width="500" height="300"></canvas>
                </div>

                <button
                    type="button"
                    onClick={this._OnClick_Button_Clear}
                    className="btn btn-secondary">
                    Очистить
                </button>
                <button
                    type="button"
                    onClick={this._OnClick_Button_Recognized}
                    className="btn btn-secondary">
                    Распознать
                </button>

                <div className="input-group mb-3">
                    <div className="input-group-prepend">
                        <span className="input-group-text" id="basic-addon1">Result:</span>
                    </div>
                    <input type="text" readonly="readonly" value={this.state.TextRecognising_Result} className="form-control" aria-describedby="basic-addon1"></input>
                </div>
            </div>
        );
    }
}

// рендеринг элемента
ReactDOM.render(
    <ReactAppPage />,
    document.getElementById("app")
)
