﻿
console.log("JS Run " + new Date());

var Page;

class PageClass {

    constructor() {
        this.api = new API_TextRecognising();

        this.canvas = new Canvas(document.getElementById("Canvas"));
        this.canvas.Set_UserWrite(true);
        this.canvas.PrintLine();

        this.Input_Result = document.getElementById("Input_Result");
        this.Button_Clear = document.getElementById('Button_Clear');
        this.Button_Recognized = document.getElementById('Button_Recognized');

        this.Button_Clear.onclick = this._OnClick_Button_Clear.bind(this);
        this.Button_Recognized.onclick = this._OnClick_Button_Recognized.bind(this);
    }

    _OnClick_Button_Clear() {
        this.canvas.ClearCanvas();
    }

    _OnClick_Button_Recognized() {
        var image = this.canvas.GetImage();

        this.api.Request_TextRecognising(image)
            .then((data) => {
                this.Input_Result.value = data.Result;
            });
    }

}


function ready() {
    Page = new PageClass();
}

document.addEventListener("DOMContentLoaded", ready);