﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Drawing;
using static NeuralNetwork.PictureWork.PictureWork;
using NeuralNetwork.Model.Neutral.CNTK;

namespace NeuralNetwork.Model.Services
{
    /// <summary>
    /// Тестовая заглушка сервиса
    /// </summary>
    public class TextRecognisingTestService : ITextRecognisingService
    {
        public bool TryOpen(byte[] image)
        {
            Bitmap bitmap = null;

            try
            {
                using (MemoryStream stream = new MemoryStream(image))
                {
                    bitmap = new Bitmap(stream);
                }
            }
            catch (Exception)
            {
                return false;
            }

            return true;            
        }

        public int Work(byte[] image)
        {
            Bitmap bitmap = null;
            try
            {
                using (MemoryStream stream = new MemoryStream(image))
                {
                    bitmap = new Bitmap(stream);
                }
            }
            catch
            {
                
            }

            if (bitmap != null)
            {
                bitmap = (RemoveTransparency(bitmap));
                var collect = FindObjects(BitmapToFloatMatrixRgbQ(bitmap));
                int res = 0; List<int> resArr = new List<int>();
                foreach (var rect in collect)
                {
                    var floatArray = BitmapToFloatArrayRgbQ(InsertBitmap(new Bitmap(bitmap.Clone(rect, bitmap.PixelFormat), new Size(20, 20)), 28, 28));
                    resArr.Add(MNIST.GetNumber(floatArray));
                }
                resArr.Reverse();
                int power = 1;
                foreach (var r in resArr)
                {
                    res += r * power;
                    power *= 10;
                }
                return res;
            }

            return -1;
        }

        public int Learn(byte[] image, int number)
        {
            Bitmap bitmap = null;
            try
            {
                using (MemoryStream stream = new MemoryStream(image))
                {
                    bitmap = new Bitmap(stream);
                }
                if (bitmap != null)
                {
                    bitmap = (RemoveTransparency(bitmap));
                    var collect = FindObjects(BitmapToFloatMatrixRgbQ(bitmap));
                    string strNumber = number.ToString();
                    if (collect.Length != strNumber.Length)
                        return -1;

                    for (int i = 0; i < collect.Length; i++)
                    {
                        var floatArray = BitmapToFloatArrayRgbQ(InsertBitmap(new Bitmap(bitmap.Clone(collect[i], bitmap.PixelFormat), new Size(20, 20)), 28, 28));
                        MNIST.WriteNumber(floatArray, int.Parse(strNumber[i].ToString()));
                    }
                }
            }
            catch
            {

            }
            return -2;
        }
    }
}
