﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.IO;

namespace NeuralNetwork.UI.Web.Models.Service
{
    /// <summary>
    /// Сервис для преобразования Base64 в byte
    /// </summary>
    public class ConvertService
    {
        public MemoryStream Base64ToStream(string base64) 
        {
            MemoryStream res = new MemoryStream();
            var data = Base64ToByte(base64);

            using (StreamWriter writer = new StreamWriter(res)) 
            {
                writer.Write(data);
            }

            res.Position = 0;
            return res;
        }

        public byte[] Base64ToByte(string base64)
        {
            return  Convert.FromBase64String(RemovePrefix(base64));
        }


        /// <summary>
        /// Удаляет лишний префикс у сообщения
        /// </summary>
        /// <param name="base64"></param>
        /// <returns></returns>
        private string RemovePrefix(string base64)
        {
            var start_data = base64.IndexOf(',');
            return base64.Substring(start_data + 1);
        }

    }
}