﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using NeuralNetwork.Model.Services;
using NeuralNetwork.UI.Web.Models.Service;
using NeuralNetwork.UI.Web.Models.ViewModel;

namespace NeuralNetwork.UI.Web.Controllers
{
    public class TextRecognisingController : Controller
    {
        readonly ITextRecognisingService TextRecognisingService
            = new TextRecognisingTestService();

        readonly ConvertService ConvertService
            = new ConvertService();


        /// <summary>
        /// Выполняет распознование цифр на изображении
        /// </summary>
        /// <param name="file">Base64 картинка</param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult Recognising(string file)
        {
            TextRecognisingResponseModel model = null;

            try
            {
                var image_data = ConvertService.Base64ToByte(file);

                if (!TextRecognisingService.TryOpen(image_data)) 
                {
                    model = new TextRecognisingResponseModel() 
                    {
                        Successe = false,
                        Message = "Ошибка. Не удалось открыть файл как изображение"
                    };

                    return Json(model);
                }
                

                model = new TextRecognisingResponseModel()
                {
                    Successe = true,
                    Message = "Ok",
                    Result = TextRecognisingService.Work(image_data)
                };
            }
            catch (Exception ex)
            {
                model = new TextRecognisingResponseModel()
                {
                    Successe = false,
                    Message = "Ошибка. В процессе обработки изображения произошла ошибка"
                };
            }

            return Json(model);
        }
    }
}