﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AppTools
{
    /// <summary>
    /// Модуль для работы с системной переменной PATH
    /// </summary>
    public class PathProvider
    {
        static readonly string VarName = "PATH";

        /// <summary>
        /// Получить список значений
        /// </summary>
        /// <returns></returns>
        public List<string> Get()
        {
            return Environment.GetEnvironmentVariable(VarName)
                .Split(';')
                .ToList();
        }

        /// <summary>
        /// Задать значения переменной
        /// </summary>
        /// <param name="path"></param>
        /// <param name="target"></param>
        public void Set(List<string> path, EnvironmentVariableTarget target)
        {
            StringBuilder path_string = new StringBuilder();
            foreach (var elem in path)
                path_string.Append(elem + ";");

            var path_value = path_string.ToString().TrimEnd(';');

            Environment.SetEnvironmentVariable(VarName, path_value, target);
        }


        /// <summary>
        /// Добавить значение, если такого нет
        /// </summary>
        /// <param name="value"></param>
        /// <param name="target"></param>
        public void AddIfNot(string value, EnvironmentVariableTarget target)
        {
            var path_values = Get();

            if (path_values.Contains(value))
            {
                return;
            }

            path_values.Add(value);
            Set(path_values, target);
        }

    }
}
