﻿using System.Web;
using System.Web.Optimization;

using System.Collections.Generic;

namespace NeuralNetwork.UI.Web
{
    public class BundleConfig
    {
        // Дополнительные сведения об объединении см. на странице https://go.microsoft.com/fwlink/?LinkId=301862
        public static void RegisterBundles(BundleCollection bundles)
        {
            bundles.Add(new ScriptBundle("~/bundles/jquery").Include(
                        "~/Scripts/jquery-{version}.js"));

            bundles.Add(new ScriptBundle("~/bundles/jqueryval").Include(
                        "~/Scripts/jquery.validate*"));

            // Используйте версию Modernizr для разработчиков, чтобы учиться работать. Когда вы будете готовы перейти к работе,
            // готово к выпуску, используйте средство сборки по адресу https://modernizr.com, чтобы выбрать только необходимые тесты.
            bundles.Add(new ScriptBundle("~/bundles/modernizr").Include(
                        "~/Scripts/modernizr-*"));

            bundles.Add(new ScriptBundle("~/bundles/bootstrap").Include(
                      "~/Scripts/bootstrap.js"));
            bundles.Add(new StyleBundle("~/Content/css").Include(
                      "~/Content/bootstrap.css",
                      "~/Content/Site/site.css"));

            SiteContent(bundles);
        }


        /// <summary>
        /// Инструменты для работы с Canvas
        /// </summary>
        /// <param name="bundles"></param>
        private static void RegisterCanvas(BundleCollection bundles) 
        {
            bundles.Add(new ScriptBundle("~/bundles/Canvas/JS")
                .Include("~/Scripts/Site/Tools/Canvas.js"));

            bundles.Add(new StyleBundle("~/bundles/Canvas/CSS")
                .Include("~/Content/Site/Tools/Canvas.css"));
        }

        /// <summary>
        /// JS классы для работы с API
        /// </summary>
        /// <param name="bundles"></param>
        private static void RegisterApi(BundleCollection bundles) 
        {
            bundles.Add(new ScriptBundle("~/bundles/API")
                .Include("~/Scripts/Site/API/*.js"));
        }

        /// <summary>
        /// JS точка входа для страниц
        /// </summary>
        /// <param name="bundles"></param>
        private static void RegisterPages(BundleCollection bundles) 
        {
            var pages = new List<string>()
            {
                "TestPage",
                "AppPage"
            };

            foreach (var elem in pages)
            {
                bundles.Add(new ScriptBundle("~/bundles/Pages/" + elem)
                    .Include("~/Scripts/Site/Pages/" + elem + ".js"));
            }
        }

        /// <summary>
        /// ReactJS
        /// </summary>
        /// <param name="bundles"></param>
        private static void RegisterReact(BundleCollection bundles)
        {
            //Важен порядок подключения
            bundles.Add(new ScriptBundle("~/bundles/React")
                .Include("~/Scripts/Site/ReactJS/react.production.min.js")
                .Include("~/Scripts/Site/ReactJS/react-dom.production.min.js")
                .Include("~/Scripts/Site/ReactJS/babel.min.js")
                );
        }

        private static void SiteContent(BundleCollection bundles) 
        {
            RegisterCanvas(bundles);
            RegisterApi(bundles);
            RegisterPages(bundles);
            RegisterReact(bundles);
        }
    }
}
