﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NeuralNetwork.Model.Services
{
    /// <summary>
    /// Интерфейс для сервиса распознования
    /// </summary>
    public interface ITextRecognisingService
    {
        /// <summary>
        /// Основной метод распознования
        /// </summary>
        /// <param name="image">картинка</param>
        /// <returns></returns>
        int Work(byte[] image);

        /// <summary>
        /// Метод обучения нейросети
        /// </summary>
        /// <param name="image">изображение</param>
        /// <param name="number">число, изображенное на картинке</param>
        /// <returns></returns>
        int Learn(byte[] image, int number);

        /// <summary>
        /// Вспомогательный метод, проверка открытия файла как картинки
        /// </summary>
        /// <param name="image"></param>
        /// <returns></returns>
        bool TryOpen(byte[] image);
    }
}
