﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.ComponentModel.DataAnnotations.Schema;

using Microsoft.AspNetCore.Identity;

namespace Tools.Identity.EF.Entities
{
    public class BaseRole<TKey, TUser, TRole>
        : IdentityRole<TKey>

        where TKey : IEquatable<TKey>
        where TUser : BaseUser<TKey, TUser, TRole>
        where TRole : BaseRole<TKey, TUser, TRole>
    {
        public virtual List<BaseUserRole<TKey, TUser, TRole>> Users { set; get; }


        [NotMapped]
        public IReadOnlyDictionary<TKey, TUser> UsersDict
        {
            get => Users
                .ToDictionary(e => e.UserId, e => e.User);
            set => Users = value
                .Select(
                    e => new BaseUserRole<TKey, TUser, TRole>()
                    {
                        UserId = e.Key,
                        User = e.Value,

                        RoleId = Id,
                        Role = (TRole)this
                    }
                )
                .ToList();
        }



        public BaseRole() { }
        public BaseRole(string roleName) 
            : base(roleName) { }
    }

}
