﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

using System.ComponentModel.DataAnnotations.Schema;

using Microsoft.AspNetCore.Identity;

namespace Tools.Identity.EF.Entities
{
    public class BaseUser<TKey, TUser, TRole>
        : IdentityUser<TKey>

        where TKey : IEquatable<TKey>
        where TUser : BaseUser<TKey, TUser, TRole>
        where TRole : BaseRole<TKey, TUser, TRole>
    {
        public virtual List<BaseUserRole<TKey, TUser, TRole>> Roles { set; get; }
            = new List<BaseUserRole<TKey, TUser, TRole>>();


        [NotMapped]
        public IReadOnlyDictionary<TKey, TRole> RolesDict
        {
            get => Roles
                .ToDictionary(e => e.RoleId, e => e.Role);
            set => Roles = value
                .Select(
                    e => new BaseUserRole<TKey, TUser, TRole>()
                    {
                        UserId = Id,
                        User = (TUser)this,

                        RoleId = e.Key,
                        Role = e.Value
                    }
                )
                .ToList();
        }


        public BaseUser() { }
    }    

}
