﻿using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.AspNetCore.Identity;

namespace Tools.Identity.EF.Entities
{
    public class BaseUserRole<TKey, TUser, TRole>
            : IdentityUserRole<TKey>

        where TKey : IEquatable<TKey>
        where TUser : BaseUser<TKey, TUser, TRole>
        where TRole : BaseRole<TKey, TUser, TRole>
    {
        public virtual TUser User { get; set; }

        public virtual TRole Role { get; set; }
    }

}
