﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Options;
//using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
//using Microsoft.AspNetCore.ApiAuthorization.IdentityServer;

using IdentityServer4.EntityFramework.Options;

using Tools.Identity.EF;

using WebFileServ.Model.Entities.Identity;
using WebFileServ.Model.Entities.FS;

namespace WebFileServ.Model.DAL.DataBase.EF
{
    public class ApplicationDbContext
        : BaseIdentityContext<
            Guid, 
            ApplicationUser, 
            ApplicationRole, 
            ApplicationUserRole
            >
    {
        public DbSet<FsItem> FsItems { set; get; }
        public DbSet<Fs_File> FsFiles { set; get; }
        public DbSet<Fs_Directory> FsDirectories { set; get; }
        public DbSet<Fs_RootDirectory> FsRootDirectories { set; get; }


        public DbSet<FsItemGroupPermission> FsItemGroupPermissions { set; get; }



        public ApplicationDbContext(
            DbContextOptions<ApplicationDbContext> options,
            IOptions<OperationalStoreOptions> operationalStoreOptions
            ) 
            : base(
                  options, 
                  operationalStoreOptions
                  )
        {            
        }


        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            optionsBuilder
                //Microsoft.EntityFrameworkCore.Proxies
                .UseLazyLoadingProxies();


            base.OnConfiguring(optionsBuilder);
        }


        protected override void OnModelCreating(ModelBuilder builder)
        {
            base.OnModelCreating(builder);


            builder.Entity<FsItemGroupPermission>()
                .HasKey(t => new { t.RoleId, t.RootDirectoryId });

            builder.Entity<FsItemGroupPermission>()
                .HasOne(sc => sc.Role)
                .WithMany(s => s.RootDirectoryPermission)
                .HasForeignKey(sc => sc.RoleId);

            builder.Entity<FsItemGroupPermission>()
                .HasOne(sc => sc.RootDirectory)
                .WithMany(c => c.GroupPermission)
                .HasForeignKey(sc => sc.RootDirectoryId);


            builder.Entity<Fs_RootDirectory>()
                .HasIndex(u => u.OwnerUserId);
            builder
                .Entity<Fs_RootDirectory>()
                .HasOne(u => u.OwnerUser)
                .WithOne(p => p.PersonalDirectory)
                .HasForeignKey<ApplicationUser>(p => p.PersonalDirectoryId);
        }

    }

}
