﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

namespace WebFileServ.Model.DAL.Migrations
{
    public partial class AddPersonalFolder : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.AddColumn<Guid>(
                name: "OwnerUserId",
                table: "FsItems",
                nullable: true);

            migrationBuilder.AddColumn<long>(
                name: "PersonalDirectoryId",
                table: "AspNetUsers",
                nullable: true);

            migrationBuilder.CreateIndex(
                name: "IX_FsItems_OwnerUserId",
                table: "FsItems",
                column: "OwnerUserId");

            migrationBuilder.CreateIndex(
                name: "IX_AspNetUsers_PersonalDirectoryId",
                table: "AspNetUsers",
                column: "PersonalDirectoryId",
                unique: true,
                filter: "[PersonalDirectoryId] IS NOT NULL");

            migrationBuilder.AddForeignKey(
                name: "FK_AspNetUsers_FsItems_PersonalDirectoryId",
                table: "AspNetUsers",
                column: "PersonalDirectoryId",
                principalTable: "FsItems",
                principalColumn: "Id",
                onDelete: ReferentialAction.Restrict);
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropForeignKey(
                name: "FK_AspNetUsers_FsItems_PersonalDirectoryId",
                table: "AspNetUsers");

            migrationBuilder.DropIndex(
                name: "IX_FsItems_OwnerUserId",
                table: "FsItems");

            migrationBuilder.DropIndex(
                name: "IX_AspNetUsers_PersonalDirectoryId",
                table: "AspNetUsers");

            migrationBuilder.DropColumn(
                name: "OwnerUserId",
                table: "FsItems");

            migrationBuilder.DropColumn(
                name: "PersonalDirectoryId",
                table: "AspNetUsers");
        }
    }
}
