﻿using System;
using System.Collections.Generic;
using System.Text;

using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Configuration;

using Microsoft.EntityFrameworkCore;

using Microsoft.AspNetCore.Identity;


using WebFileServ.Model.Entities.Identity;

using WebFileServ.Model.DAL.DataInit;
using WebFileServ.Model.DAL.DataBase.EF;

using WebFileServ.Model.BLL;

namespace WebFileServ.Model.DI
{

    public enum AppEnviroment 
    {
        WebApp,
        UnitTests,
        ConsoleTest
    }


    public class DIManager
    {
        public AppEnviroment Enviroment { private set; get; }

        public DIManager(AppEnviroment enviroment) 
        {
            Enviroment = enviroment;
        }

        public void Registry(IServiceCollection services, IConfiguration configuration) 
        {
            if (configuration != null)
            {
                foreach (var elem in configuration.AsEnumerable())
                {
                    System.Diagnostics.Trace.WriteLine($"{elem.Key} | {elem.Value}");
                }
            }


            RegistryDAL(services, configuration);

            RegustryIdentity(services, configuration);

            RegistryBLL(services, configuration);
        }



        private void RegistryDAL(IServiceCollection services, IConfiguration configuration) 
        {
            services
                .AddSingleton(configuration);
            services
                .AddSingleton<DataInitializerConfig>();



            //if (Enviroment == EnumEnviroment.WebApp)
            //{
            services.AddDbContext<ApplicationDbContext>(options =>
                        options.UseSqlServer(
                            configuration.GetConnectionString("DefaultConnection")
                        )
                    );
            //}
            //else 
            //{
            //    services.AddDbContext<ApplicationDbContext>(options =>
            //            options.UseInMemoryDatabase("TestDb")
            //        );
            //}

            services
                .AddScoped<DataInitializer>();
        }

        private void RegustryIdentity(IServiceCollection services, IConfiguration configuration) 
        {
            if (Enviroment != AppEnviroment.UnitTests)
            {
                services
                    .AddDefaultIdentity<ApplicationUser>(
                        options =>
                        {
                            options.SignIn.RequireConfirmedAccount = false;

                            options.Password = new PasswordOptions()
                            {
                                RequiredLength = 0,
                                RequireDigit = false,
                                RequiredUniqueChars = 0,
                                RequireLowercase = false,
                                RequireUppercase = false,
                                RequireNonAlphanumeric = false
                            };
                        }
                    )
                    .AddRoles<IdentityRole>()
                    .AddEntityFrameworkStores<ApplicationDbContext>();

                services.AddIdentityServer()
                .AddApiAuthorization<ApplicationUser, ApplicationDbContext>();
            }            
        }

        private void RegistryBLL(IServiceCollection services, IConfiguration configuration) 
        {
            services
                .AddSingleton<WeatherForecastLogic>();
        }

    }
}
