import React, { Component } from 'react';
import authService from '../components/api-authorization/AuthorizeService'
import { FetchDataDAL } from '../Model/DAL/FetchDataDAL'

export class FetchDataPage extends Component {
    static displayName = FetchDataPage.name;

    constructor(props) {
        super(props);
        this.state = { forecasts: [], loading: true };

        this.DAL = new FetchDataDAL();
    }

    componentDidMount()
    {
        this.LoadWeatherData();
    }

    async LoadWeatherData() {

        const data = await this.DAL.GetWeatherData();
        this.setState
            (
            {
                forecasts: data,
                loading: false
            }
        );
    }

    static renderForecastsTable(forecasts) {
        return (
            <table className='table table-striped' aria-labelledby="tabelLabel">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Temp. (C)</th>
                        <th>Temp. (F)</th>
                        <th>Summary</th>
                    </tr>
                </thead>
                <tbody>
                    {forecasts.map(forecast =>
                        <tr key={forecast.date}>
                            <td>{forecast.date}</td>
                            <td>{forecast.temperatureC}</td>
                            <td>{forecast.temperatureF}</td>
                            <td>{forecast.summary}</td>
                        </tr>
                    )}
                </tbody>
            </table>
        );
    }

    render() {
        let contents = this.state.loading
            ? <p><em>Loading...</em></p>
            : FetchDataPage.renderForecastsTable(this.state.forecasts);

        return (
            <div>
                <h1 id="tabelLabel" >Weather forecast</h1>
                <p>This component demonstrates fetching data from the server.</p>
                {contents}
            </div>
        );
    }
}
