﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.Extensions.Configuration;

namespace WebFileServ.Model.DAL.DataInit
{
    public class DataInitializerConfig
    {
        /// <summary>
        /// Удалять базу при каждом запуске приложения.
        /// !!Внимание использовать только для тестовой среды.
        /// </summary>
        public bool ReCreateDataBase { private set; get; }

        /// <summary>
        /// Автоматически применять миграцию при запуске приложения
        /// </summary>
        public bool AutoApplyMigration { private set; get; }

        /// <summary>
        /// Наполнить БД
        /// </summary>
        public bool FillData { private set; get; }



        public DataInitializerConfig(IConfiguration configuration) 
        {
            var configSection = configuration
                .GetSection("DataInitializerConfig");

            ReCreateDataBase = configSection.GetValue<bool>("ReCreateDataBase");
            AutoApplyMigration = configSection.GetValue<bool>("AutoApplyMigration");
            FillData = configSection.GetValue<bool>("FillData");
        }
    }
}
