
using System;

using Microsoft.VisualStudio.TestTools.UnitTesting;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Configuration;

using WebFileServ.Model.DI;

using WebFileServ.Model.BLL;

namespace WebFileServ.Test.UnitTests
{
    /// <summary>
    /// ,     - 
    /// </summary>
    [TestClass]
    public class DITest
    {
        private readonly ServiceProvider ServiceLocator;
        private readonly IConfiguration Configuration;

        public DITest() 
        {
            Configuration = new ConfigurationBuilder()
                .AddJsonFile("appsettings.json")
                .Build();


            var manager = new DIManager(AppEnviroment.UnitTests);            
            ServiceCollection services = new ServiceCollection();          

            manager
                .Registry(services, Configuration);

            ServiceLocator = services
                .BuildServiceProvider();
        }


        [TestMethod]
        public void WeatherForecastLogicTest()
        {
            var weatherForecastLogic = ServiceLocator
                .GetService<WeatherForecastLogic>();

            if (weatherForecastLogic == null)
            {
                throw new Exception();
            }
        }
    }
}
