﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;

using WebFileServ.Model.BLL;
using WebFileServ.Model.Entities;

namespace WebFileServ.WebApp.Controllers
{
    [Authorize]
    [ApiController]
    [Route("[controller]")]
    public class WeatherForecastController : ControllerBase
    {
        private readonly WeatherForecastLogic WeatherForecastLogic;

        private readonly ILogger<WeatherForecastController> _logger;

        public WeatherForecastController(
            ILogger<WeatherForecastController> logger,
            WeatherForecastLogic weatherForecastLogic
            )
        {
            _logger = logger;
            WeatherForecastLogic = weatherForecastLogic;
        }

        [HttpGet]
        public IEnumerable<WeatherForecast> Get()
        {
            return WeatherForecastLogic.Get();
        }
    }
}
