﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using System.ComponentModel.DataAnnotations.Schema;

using Tools.Identity.EF.Entities;

namespace WebFileServ.Entitites.Identity
{
    public class ApplicationUser
        : BaseUser<long, ApplicationUser, ApplicationRole>,
        IUserWithRoles<long, ApplicationUser, ApplicationRole>
    {
        public virtual List<AspNetUserRoles<long, ApplicationUser, ApplicationRole>> Roles { set; get; }
            = new List<AspNetUserRoles<long, ApplicationUser, ApplicationRole>>();

        [NotMapped]
        public Dictionary<long, ApplicationRole> RolesDict 
        { 
            get => Roles.ToDictionary(e => e.RoleId, e => e.Role);
            set => Roles = value
                .Select(
                    e => new AspNetUserRoles<long, ApplicationUser, ApplicationRole>()
                    { 
                        UserId = Id,
                        User = this,
                        RoleId = e.Key,
                        Role = e.Value
                    }
                )
                .ToList();
        }
    }

}
