import React, { Component } from 'react';
import { Route } from 'react-router';
import { Layout } from './Layout/Layout';
import { HomePage } from './Pages/HomePage';
import { FetchDataPage } from './Pages/FetchDataPage';
import { CounterPage } from './Pages/CounterPage';
import { UserPage } from './Pages/UserPage';
import AuthorizeRoute from './components/api-authorization/AuthorizeRoute';
import ApiAuthorizationRoutes from './components/api-authorization/ApiAuthorizationRoutes';
import { ApplicationPaths } from './components/api-authorization/ApiAuthorizationConstants';

import './custom.css'

export default class App extends Component {
    static displayName = App.name;

    render() {
        return (
            <Layout>
                <Route exact path='/' component={HomePage} />
                <Route path='/counter' component={CounterPage} />
                <AuthorizeRoute path='/fetch-data' component={FetchDataPage} />
                <AuthorizeRoute path='/userPage' component={UserPage} />
                <Route path='/swagger' component={
                    () =>
                    {
                        window.location.href = '/swagger/index.html';
                        return null;
                    }
                } />

                <Route path={ApplicationPaths.ApiAuthorizationPrefix} component={ApiAuthorizationRoutes} />
            </Layout>
        );
    }
}
