﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using System.ComponentModel.DataAnnotations.Schema;

using Tools.Identity.EF.Entities;

namespace WebFileServ.Entitites.Identity
{
    public class ApplicationRole
        : BaseRole<long, ApplicationUser, ApplicationRole>,
          IRoleWithUsers<long, ApplicationUser, ApplicationRole>
    {
        public virtual List<AspNetUserRoles<long, ApplicationUser, ApplicationRole>> Users { set; get; }
            = new List<AspNetUserRoles<long, ApplicationUser, ApplicationRole>>();

        [NotMapped]
        public Dictionary<long, ApplicationUser> UsersDict
        {
            get => Users.ToDictionary(e => e.UserId, e => e.User);
            set => Users = value
                .Select(
                    e => new AspNetUserRoles<long, ApplicationUser, ApplicationRole>()
                    {
                        RoleId = Id,
                        Role = this,
                        UserId = e.Key,
                        User = e.Value
                    }
                )
                .ToList();
        }


        public ApplicationRole() { }
        public ApplicationRole(string roleName) : base(roleName) { }
    }

}
