﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Options;
//using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
//using Microsoft.AspNetCore.ApiAuthorization.IdentityServer;

using IdentityServer4.EntityFramework.Options;

using Tools.Identity.EF;

using WebFileServ.Model.Entities.Identity;

namespace WebFileServ.Model.DAL.DataBase.EF
{
    public class ApplicationDbContext
        : BaseIdentityContext<
            Guid, 
            ApplicationUser, 
            ApplicationRole, 
            ApplicationUserRole
            >
    {

        public ApplicationDbContext(
            DbContextOptions<ApplicationDbContext> options,
            IOptions<OperationalStoreOptions> operationalStoreOptions
            ) 
            : base(
                  options, 
                  operationalStoreOptions
                  )
        {            
        }


        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            optionsBuilder
                //Microsoft.EntityFrameworkCore.Proxies
                .UseLazyLoadingProxies();


            base.OnConfiguring(optionsBuilder);
        }
        
    }

}
