﻿using System;

using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Configuration;

using WebFileServ.Model.DI;

using WebFileServ.Model.DAL.DataInit;
using WebFileServ.Model.BLL;

namespace WebFileServ.Test.ConsoleTest
{
    class Program
    {
        private static readonly ServiceProvider ServiceLocator;
        private static readonly IConfiguration Configuration;

        static Program()
        {
            Configuration = new ConfigurationBuilder()
                .AddJsonFile("appsettings.json")
                .Build();


            var manager = new DIManager(AppEnviroment.ConsoleTest);
            ServiceCollection services = new ServiceCollection();

            manager
                .Registry(services, Configuration);

            ServiceLocator = services
                .BuildServiceProvider();
        }



        static void Main(string[] args)
        {
            using (var dataInit = ServiceLocator.GetService<DataInitializer>()) 
            {
                Console.WriteLine("Старт иницилизации данными");
                Console.WriteLine(Configuration.GetConnectionString("DefaultConnection"));

                dataInit.Init()
                    .GetAwaiter()
                    .GetResult();
                Console.WriteLine("Иницилизация данных завершена");
            }
        }
    }
}
