﻿using System;
using Microsoft.EntityFrameworkCore.Migrations;

namespace WebFileServ.Model.DAL.Migrations
{
    public partial class AddFs : Migration
    {
        protected override void Up(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.CreateTable(
                name: "FsItems",
                columns: table => new
                {
                    Id = table.Column<long>(nullable: false)
                        .Annotation("SqlServer:Identity", "1, 1"),
                    Discriminator = table.Column<string>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_FsItems", x => x.Id);
                });

            migrationBuilder.CreateTable(
                name: "FsItemGroupPermissions",
                columns: table => new
                {
                    RootDirectoryId = table.Column<long>(nullable: false),
                    RoleId = table.Column<Guid>(nullable: false),
                    Permission = table.Column<int>(nullable: false)
                },
                constraints: table =>
                {
                    table.PrimaryKey("PK_FsItemGroupPermissions", x => new { x.RoleId, x.RootDirectoryId });
                    table.ForeignKey(
                        name: "FK_FsItemGroupPermissions_AspNetRoles_RoleId",
                        column: x => x.RoleId,
                        principalTable: "AspNetRoles",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Cascade);
                    table.ForeignKey(
                        name: "FK_FsItemGroupPermissions_FsItems_RootDirectoryId",
                        column: x => x.RootDirectoryId,
                        principalTable: "FsItems",
                        principalColumn: "Id",
                        onDelete: ReferentialAction.Cascade);
                });

            migrationBuilder.CreateIndex(
                name: "IX_FsItemGroupPermissions_RootDirectoryId",
                table: "FsItemGroupPermissions",
                column: "RootDirectoryId");
        }

        protected override void Down(MigrationBuilder migrationBuilder)
        {
            migrationBuilder.DropTable(
                name: "FsItemGroupPermissions");

            migrationBuilder.DropTable(
                name: "FsItems");
        }
    }
}
