﻿using System;
using System.Collections.Generic;
using System.Text;

using System.ComponentModel.DataAnnotations.Schema;

using WebFileServ.Model.Entities.Identity;

namespace WebFileServ.Model.Entities.FS
{
    public class FsItem
    {
        public long Id { set; get; }    
    }


    public class Fs_File
        : FsItem
    {
    }


    public class Fs_RootDirectory 
        : Fs_Directory
    {

        [NotMapped]
        public bool IsPersonalDirectory 
            => OwnerUserId.HasValue;

        public Guid? OwnerUserId { set; get; }
        public virtual ApplicationUser OwnerUser { set; get; }


        public virtual List<FsItemGroupPermission> GroupPermission { set; get; }
            = new List<FsItemGroupPermission>();
    }

    public class Fs_Directory
        : FsItem
    { 
    
    }

}
