import React, { Component } from 'react';
import authService from '../components/api-authorization/AuthorizeService';

export class UserPage extends Component {
    static displayName = UserPage.name;


    constructor(props) {
        super(props);

        this.state = {
            isAuthenticated: false,
            userName: null
        };
    }

    componentDidMount() {
        this._subscription = authService.subscribe(() => this.populateState());
        this.populateState();
    }

    componentWillUnmount() {
        authService.unsubscribe(this._subscription);
    }

    async populateState() {
        const [isAuthenticated, user] = await Promise.all(
            [
                authService.isAuthenticated(),
                authService.getUser()
            ]
        )

        this.setState(
            {
                isAuthenticated,
                userName: user && user.name
            }
        );
    }

    render() {
        return (
            <div>
                <h1 id="tabelLabel" >User SPA page</h1>
                <p></p>
                { this.state.userName }
            </div>
        );
    }
}
