﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Options;

using IdentityServer4.EntityFramework.Options;

using Tools.Identity.EF;

using WebFileServ.Entitites.Identity;

namespace WebFileServ.DAL.DataBase.EF
{
    public class ApplicationDbContext 
        : BaseIdentityContext<
            long, 
            ApplicationUser, 
            ApplicationRole
            >
    {
        public ApplicationDbContext(
            DbContextOptions<ApplicationDbContext> options,
            IOptions<OperationalStoreOptions> operationalStoreOptions
            ) 
            : base(
                  options, 
                  operationalStoreOptions
                  )
        {            
        }


        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            optionsBuilder
                //Microsoft.EntityFrameworkCore.Proxies
                .UseLazyLoadingProxies();

            base.OnConfiguring(optionsBuilder);
        }

        protected override void OnModelCreating(ModelBuilder builder)
        {           
            //AutoincrementId
            builder
                .Entity<ApplicationUser>(
                    e => e
                        .Property(e2 => e2.Id)
                        .UseIdentityColumn()                        
                );
            builder
                .Entity<ApplicationRole>(
                    e => e
                        .Property(e2 => e2.Id)
                        .UseIdentityColumn()
                );

            base.OnModelCreating(builder);
        }
    }

}
