﻿


function SetStyle(element, style) {
    for (const [key, value] of Object.entries(style)) {
        element.style[key] = value;
    }
}

function Validate(elements, styles){

    for (let i = 0; i < elements.length; i++) {
        let elem_style = window.getComputedStyle(elements[i]);

        for (const [key, value] of Object.entries(styles[i])) {
            let elem_style_value = elem_style[key];

            if (elem_style_value !== value)
                return false
        }
    }

    return true;
}


function CSS_IT() {
    document.getElementById("style").innerHTML = document.getElementById("User_CSS").value;
}

function Click_Validate() {
    let elements = document.getElementById("View_User").children;
    let styles =
        [
            {
                color: "rgb(255, 0, 0)"
            },
            {
                color: "rgb(0, 128, 0)"
            },
            {
                color: "rgb(0, 0, 255)"
            }
        ];

    let res = Validate(elements, styles);
    document.getElementById("Validate").value = res;
}

function ready() {
    document.getElementById("B").onclick = CSS_IT;
    document.getElementById("V").onclick = Click_Validate;
}

document.addEventListener("DOMContentLoaded", ready);