using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;

using System.IO;

using Newtonsoft.Json.Linq;

using Tools.SingletonTool.Manager;

using Learn_CSS.APP.Web.Models.Entities;
using Learn_CSS.APP.Web.Models.ViewEntity;
using Learn_CSS.APP.Web.Models.ModelBinders;
using Learn_CSS.APP.Web.Models.Services;

namespace Learn_CSS.APP.Web
{
    public class MvcApplication : System.Web.HttpApplication
    {
        static readonly string TaskDirectory = "Tasks";

        public string GetPath_App_Data => Server.MapPath("~/App_Data");

        protected void Application_Start()
        {
            AreaRegistration.RegisterAllAreas();
            FilterConfig.RegisterGlobalFilters(GlobalFilters.Filters);
            RouteConfig.RegisterRoutes(RouteTable.Routes);
            BundleConfig.RegisterBundles(BundleTable.Bundles);




            RegisterModelBinders();
            RegisterTaskStorage();

        }

        private void RegisterModelBinders() 
        {
            ModelBinders.Binders.Add(typeof(JObject), new JsonModelBinder());
            ModelBinders.Binders.Add(typeof(ValidateEntity), new ValidateEntityBinder());
        }

        private void RegisterTaskStorage() 
        {
            var stor = 
                new SignlethonWithParamsManager<Storage, StorageParams>(new StorageParams()
            {
                Directory = Server.MapPath("~/AppData"),
                TaskSerializerService = new TaskSerializerService('|')
            }).Get();

            stor.Load();

            if (stor.data.Count == 0) 
            {
                for (int i = 0; i < 2; i++)
                {
                    stor.data.Add(new TaskEntity() 
                    {
                        HTML_Text = "Text " + i,
                        HTML_Template = "Template " + i,
                        JSON_Result = "Result " + i
                    });
                }
            }

            stor.Save();
        }

    }
}
