﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Microsoft.Extensions.DependencyInjection;


using Learn_CSS.Model.DAL;
using Learn_CSS.Model.DAL.Serialization;

using Learn_CSS.Model.BLL;

namespace Learn_CSS.DI
{
    public static class DiRegistry
    {
        public static IServiceProvider ServiceLocator { private set; get; }
        public static T Resolve<T>()
            => ServiceLocator.GetService<T>();

        public static string AppPath { private set; get; }

        public static void SetupRegistry(string appPath)
        {
            AppPath = appPath;

            ServiceCollection services = new ServiceCollection();

            RegistryDAL(services);
            RegistryBLL(services);

            ServiceLocator = services.BuildServiceProvider();
        }


        private static void RegistryDAL(IServiceCollection services) 
        {
            services
                .AddSingleton<TaskSerializerService>()
                .AddSingleton<CSSTaskStorage>(
                    e => new CSSTaskStorage(AppPath, Resolve<TaskSerializerService>())
                );
        }
        private static void RegistryBLL(IServiceCollection services) 
        {
            services
                .AddSingleton<JsonIncludeService>()
                .AddSingleton<TaskService>();
        }

    }
}
