﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using Newtonsoft.Json.Linq;

using Tools.SingletonTool.Manager;

using Learn_CSS.APP.Web.Models.Entities;
using Learn_CSS.APP.Web.Models.ViewEntity;
using Learn_CSS.APP.Web.Models.Services;

namespace Learn_CSS.APP.Web.Controllers
{
    public class ApiTaskController : Controller
    {
        private readonly JsonIncludeService jsonIncludeService
            = new JsonIncludeService();

        private readonly Storage Storage
            = new SignlethonWithParamsManager<Storage, StorageParams>().Get();

        private readonly TaskService taskService
            = new TaskService(new JsonIncludeService());


        [HttpGet]
        public JsonResult Count()
        {
            return Json(Storage.data.Count, JsonRequestBehavior.AllowGet);
        }


        [HttpGet]
        public JsonResult ReadTasks()
        {
            try
            {
                Storage.Load();
            }
            catch (Exception ex)
            {
                string full_message = "";

                for (var e = ex; e != null; e = e.InnerException)
                    full_message += e.Message;

                return Json(new { Successe = false, Message = full_message, Stack = ex.StackTrace }, JsonRequestBehavior.AllowGet);
            }

            return Json(new { Successe = true }, JsonRequestBehavior.AllowGet);
        }

        [HttpPost]
        public JsonResult GetTask(int ID)
        {
            var task = Storage.data[ID];

            return Json(task, JsonRequestBehavior.AllowGet);
        }



        [HttpPost]
        public JsonResult Validate(ValidateEntity entity)
        {
            var task = Storage.data[entity.ID];

            var result = taskService.Validate(task, entity);

            return Json(result);
        }
    }
}