﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.SessionState;

using Newtonsoft.Json.Linq;

using Learn_CSS.APP.Web.Models.Services;

namespace Learn_CSS.APP.Web.Controllers
{
    public class AppController : Controller
    {
        private readonly JsonIncludeService jsonIncludeService 
            = new JsonIncludeService();


        // GET: App
        public ActionResult Index()
        {
            return View();
        }


        [HttpPost]
        public JsonResult Validate_CSS(JObject model) 
        {
            var result = jsonIncludeService.Include(model, model);

            return Json(result);
        }
        
    }
}