﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.SessionState;

using Newtonsoft.Json.Linq;

using Learn_CSS.DI;

using Learn_CSS.Model.BLL;

namespace Learn_CSS.APP.Web.Controllers
{
    public class AppController : Controller
    {
        private readonly JsonIncludeService JsonIncludeService;



        public AppController() 
        {
            JsonIncludeService = DiRegistry.Resolve<JsonIncludeService>();
        }


        // GET: App
        public ActionResult Index()
        {
            return View();
        }


        [HttpPost]
        public JsonResult Validate_CSS(JObject model) 
        {
            var result = JsonIncludeService.Include(model, model);

            return Json(result);
        }
        
    }
}