﻿

class ApiProvider {

    constructor() {
        this.URL_Count = "/ApiTask/Count";
        this.URL_GetTask = "/ApiTask/GetTask";
        this.URL_Validate = "/ApiTask/Validate"; 

        this.URL = "/App/Validate_CSS";
    }



    async Count() {

        console.log("Api request:" + this.URL_Count);

        let response = await fetch(this.URL_Count,
            {
                method: 'GET',
                headers: {
                    "Content-Type": "application/json"
                }
            }
        );
        let json = await response.json();


        return json;
    }

    async GetTask(ID) {

        console.log("Api request:" + this.URL_GetTask);

        let response = await fetch(this.URL_GetTask,
            {
                method: 'POST',
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify(
                {
                    ID: ID
                })
            }
        );
        let json = await response.json();

        return json;
    }

    async Validate(ID, styles) {

        console.log("Api request:" + this.URL_Validate);

        let response = await fetch(this.URL_Validate,
            {
                method: 'POST',
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    ID: ID,
                    Elements: styles
                })
            }
        );
        let json = await response.json();


        return json;
    }

}