﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

using Learn_CSS.APP.Web.Models.Services;


namespace Learn_CSS.Test.Unit
{
    [TestClass]
    public class Test_IncludeService
    {
        private readonly JsonIncludeService JsonIncludeService 
            = new JsonIncludeService();

        #region

        string TestData1 = @"
{ 
    a: {
            a1:10, 
            a2:20
       }, 
    b:""b1"", 
    ar:
        [
            1,
            2,
            3
        ]
}";

        string TestData2 = @"
{ 
    a: {
            a1:10, 
            a2:20
       }, 
}";

        string TestData3 = @"
{ 
    b:""b1"", 
}";

        string TestData4 = @"
{ 
    ar:
        [
            1,
            2,
            3
        ]
}";

        #endregion


        [TestMethod]
        public void Test1()
        {
            var json = (JObject)JsonConvert.DeserializeObject(TestData1);

            var res = JsonIncludeService.Include(json, json);

            if (!res)
                throw new Exception();
        }

        [TestMethod]
        public void Test2()
        {
            var json_main = (JObject)JsonConvert.DeserializeObject(TestData1);
            var json_sub = (JObject)JsonConvert.DeserializeObject(TestData2);

            var res = JsonIncludeService.Include(json_main, json_sub);

            if (!res)
                throw new Exception();
        }

        [TestMethod]
        public void Test3()
        {
            var json_main = (JObject)JsonConvert.DeserializeObject(TestData1);
            var json_sub = (JObject)JsonConvert.DeserializeObject(TestData3);

            var res = JsonIncludeService.Include(json_main, json_sub);

            if (!res)
                throw new Exception();
        }

        [TestMethod]
        public void Test4()
        {
            var json_main = (JObject)JsonConvert.DeserializeObject(TestData1);
            var json_sub = (JObject)JsonConvert.DeserializeObject(TestData4);

            var res = JsonIncludeService.Include(json_main, json_sub);

            if (!res)
                throw new Exception();
        }


    }
}
