﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Learn_SQL.Model.Entities;

using Learn_SQL.Model.DAL;

namespace Learn_SQL.Model.BLL
{
    public class SqlTester
    {
        private readonly ISqlTaskStorage SqlTaskStorage;
        private readonly IDbExecuter DbExecuter;


        public SqlTester(
            ISqlTaskStorage sqlTaskStorage,
            IDbExecuter dbExecuter
            )
        {
            SqlTaskStorage = sqlTaskStorage;
            DbExecuter = dbExecuter;
        }


        public bool Test(UserSolution userSolution)
        {
            var task = SqlTaskStorage.GetTask(userSolution.TaskId);

            var correctResult = DbExecuter.ExecteSelectQuery(task.CorrectSolution);
            var userResult = DbExecuter.ExecteSelectQuery(userSolution.UserQuery);

            if (correctResult.Rows.Count != userResult.Rows.Count)
            {
                return false;
            }

            if (correctResult.Columns.Count != userResult.Columns.Count) 
            {
                return false;
            }


            for (int i = 0; i < correctResult.Rows.Count; i++)
            {
                for (int j = 0; j < correctResult.Columns.Count; j++)
                {
                    var eql = 
                        correctResult.Rows[i].ItemArray[j].Equals(
                            userResult.Rows[i].ItemArray[j]
                            );

                    if (!eql)
                    {
                        return false;
                    }
                }
            }

            return true;
        }
    }
}
