﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Data;
using System.Data.SqlClient;

namespace Learn_SQL.Model.DAL
{
    public interface IDbExecuter
    {
        DataTable ExecteSelectQuery(string query);
    }

    public class DbExecute 
        : IDbExecuter
    {
        private readonly string ConnectionString;

        public DbExecute(string connectionString)
        {
            ConnectionString = connectionString;
        }


        public DataTable ExecteSelectQuery(string query)
        {
            using (SqlConnection connection = new SqlConnection(ConnectionString))
            using (SqlCommand command = new SqlCommand(query, connection))
            using (SqlDataAdapter adapter = new SqlDataAdapter(command))
            {
                DataTable result = new DataTable();
                adapter.Fill(result);

                return result;
            }
        }
    }

}
