﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

using Learn_CSS.Model.Entities;

namespace Learn_CSS.Model.BLL
{
    public class TaskService
    {
        private readonly JsonIncludeService jsonIncludeService;

        public TaskService(JsonIncludeService jsonIncludeService) 
        {
            this.jsonIncludeService = jsonIncludeService;
        }

        public bool Validate(TaskEntity task, ValidateEntity entity) 
        {
            var sub_style = (JObject)JsonConvert.DeserializeObject(task.JSON_Result);
            var sub_properties = sub_style.Properties().ToList();

            var main_styles = (JArray)entity.Elements;

            for (int i = 0; i < sub_properties.Count; i++)
            {
                var sub_elem = sub_properties[i].First();
                var main_style = main_styles.Children().ToList()[i];


                if (!jsonIncludeService.Include(main_style, sub_elem))
                {
                    return false;
                }
            }

            return true;
        }


        //public bool ValidateEntity() 
        //{
        
        //}
    }
}