﻿using System;
using System.Collections.Generic;

#nullable disable

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace Calibre.Model.Database.Entities
{
    public partial class BooksTagsLink
    {
        public long Id { get; set; }

        public long Book { get; set; }
        public virtual Book BookItem { get; set; }

        public long Tag { get; set; }
        public virtual Tag TagItem { get; set; }


        public override string ToString()
        {
            return $"{Tag}|{TagItem?.Name}|{Book}|{BookItem?.Title}";
        }


        internal static void EfSetup(
            EntityTypeBuilder<BooksTagsLink> entity
            ) 
        {
            entity.ToTable("books_tags_link");

            entity.HasIndex(e => new { e.Book, e.Tag }, "IX_books_tags_link_book_tag")
                .IsUnique();

            entity.HasIndex(e => e.Tag, "books_tags_link_aidx");

            entity.HasIndex(e => e.Book, "books_tags_link_bidx");

            entity.Property(e => e.Id)
                .ValueGeneratedNever()
                .HasColumnName("id");

            entity.Property(e => e.Book).HasColumnName("book");

            entity.Property(e => e.Tag).HasColumnName("tag");


            entity
                .HasOne(e => e.BookItem)
                .WithMany(e => e.Tags)
                .HasForeignKey(e => e.Book);
            entity
                .HasOne(e => e.TagItem)
                .WithMany(e => e.Books)
                .HasForeignKey(e => e.Tag);
        }
    }
}
