﻿using System;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata;

#nullable disable

using System.IO;

using Calibre.Model.Database.Entities;

namespace Calibre.Model.Database
{
    public partial class CalibreContext 
        : DbContext
    {
        #region

        public string ConnectionString { private set; get; }

        public bool AsNoTracking { set; get; }
        //public DirectoryInfo LibraryDirectory { set; get; }


        #region Sets

        public virtual DbSet<Annotation> Annotations { get; set; }
        public virtual DbSet<AnnotationsDirtied> AnnotationsDirtieds { get; set; }
        public virtual DbSet<AnnotationsFt> AnnotationsFts { get; set; }
        public virtual DbSet<AnnotationsFtsConfig> AnnotationsFtsConfigs { get; set; }
        public virtual DbSet<AnnotationsFtsDatum> AnnotationsFtsData { get; set; }
        public virtual DbSet<AnnotationsFtsDocsize> AnnotationsFtsDocsizes { get; set; }
        public virtual DbSet<AnnotationsFtsIdx> AnnotationsFtsIdxes { get; set; }
        public virtual DbSet<AnnotationsFtsStemmed> AnnotationsFtsStemmeds { get; set; }
        public virtual DbSet<AnnotationsFtsStemmedConfig> AnnotationsFtsStemmedConfigs { get; set; }
        public virtual DbSet<AnnotationsFtsStemmedDatum> AnnotationsFtsStemmedData { get; set; }
        public virtual DbSet<AnnotationsFtsStemmedDocsize> AnnotationsFtsStemmedDocsizes { get; set; }
        public virtual DbSet<AnnotationsFtsStemmedIdx> AnnotationsFtsStemmedIdxes { get; set; }
        public virtual DbSet<Author> Authors { get; set; }
        public virtual DbSet<Book> Books { get; set; }
        public virtual DbSet<BooksAuthorsLink> BooksAuthorsLinks { get; set; }
        public virtual DbSet<BooksLanguagesLink> BooksLanguagesLinks { get; set; }
        public virtual DbSet<BooksPluginDatum> BooksPluginData { get; set; }
        public virtual DbSet<BooksPublishersLink> BooksPublishersLinks { get; set; }
        public virtual DbSet<BooksRatingsLink> BooksRatingsLinks { get; set; }
        public virtual DbSet<BooksSeriesLink> BooksSeriesLinks { get; set; }
        public virtual DbSet<BooksTagsLink> BooksTagsLinks { get; set; }
        public virtual DbSet<Comment> Comments { get; set; }
        public virtual DbSet<ConversionOption> ConversionOptions { get; set; }
        public virtual DbSet<CustomColumn> CustomColumns { get; set; }
        public virtual DbSet<Data> FileData { get; set; }
        public virtual DbSet<Feed> Feeds { get; set; }
        public virtual DbSet<Identifier> Identifiers { get; set; }
        public virtual DbSet<Language> Languages { get; set; }
        public virtual DbSet<LastReadPosition> LastReadPositions { get; set; }
        public virtual DbSet<LibraryId> LibraryIds { get; set; }
        public virtual DbSet<MetadataDirtied> MetadataDirtieds { get; set; }
        public virtual DbSet<Preference> Preferences { get; set; }
        public virtual DbSet<Publisher> Publishers { get; set; }
        public virtual DbSet<Rating> Ratings { get; set; }
        public virtual DbSet<Series> Series { get; set; }
        public virtual DbSet<Tag> Tags { get; set; }

        #endregion

        #endregion
        

        [Obsolete]
        public CalibreContext()
        {
            SetupContext();
        }

        /// <summary>
        /// </summary>
        /// <param name="connectionString">Filename=D:\\metadata.db</param>
        public CalibreContext(string connectionString)
        {
            ConnectionString = connectionString;
            SetupContext();
        }

        //public CalibreContext(DbContextOptions<CalibreContext> options)
        //    : base(options)
        //{
        //}


        #region BuildModel

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            if (!optionsBuilder.IsConfigured)
            {
                optionsBuilder
                    .UseSqlite(ConnectionString);
            }
        }

        protected override void OnModelCreating(ModelBuilder modelBuilder)
        {
            modelBuilder.Entity<Annotation>(entity =>
            {
                entity.ToTable("annotations");

                entity.HasIndex(e => new { e.Book, e.UserType, e.User, e.Format, e.AnnotType, e.AnnotId }, "IX_annotations_book_user_type_user_format_annot_type_annot_id")
                    .IsUnique();

                entity.HasIndex(e => e.Book, "annot_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.AnnotData)
                    .IsRequired()
                    .HasColumnName("annot_data");

                entity.Property(e => e.AnnotId)
                    .IsRequired()
                    .HasColumnName("annot_id");

                entity.Property(e => e.AnnotType)
                    .IsRequired()
                    .HasColumnName("annot_type");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Format)
                    .IsRequired()
                    .HasColumnName("format");

                entity.Property(e => e.SearchableText)
                    .IsRequired()
                    .HasColumnName("searchable_text")
                    .HasDefaultValueSql("\"\"");

                entity.Property(e => e.Timestamp).HasColumnName("timestamp");

                entity.Property(e => e.User)
                    .IsRequired()
                    .HasColumnName("user");

                entity.Property(e => e.UserType)
                    .IsRequired()
                    .HasColumnName("user_type");
            });

            modelBuilder.Entity<AnnotationsDirtied>(entity =>
            {
                entity.ToTable("annotations_dirtied");

                entity.HasIndex(e => e.Book, "IX_annotations_dirtied_book")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");
            });

            modelBuilder.Entity<AnnotationsFt>(entity =>
            {
                entity.HasNoKey();

                entity.ToTable("annotations_fts");

                entity.Property(e => e.SearchableText).HasColumnName("searchable_text");
            });

            modelBuilder.Entity<AnnotationsFtsConfig>(entity =>
            {
                entity.HasKey(e => e.K);

                entity.ToTable("annotations_fts_config");

                entity.Property(e => e.K).HasColumnName("k");

                entity.Property(e => e.V).HasColumnName("v");
            });

            modelBuilder.Entity<AnnotationsFtsDatum>(entity =>
            {
                entity.ToTable("annotations_fts_data");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Block).HasColumnName("block");
            });

            modelBuilder.Entity<AnnotationsFtsDocsize>(entity =>
            {
                entity.ToTable("annotations_fts_docsize");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Sz).HasColumnName("sz");
            });

            modelBuilder.Entity<AnnotationsFtsIdx>(entity =>
            {
                entity.HasKey(e => new { e.Segid, e.Term });

                entity.ToTable("annotations_fts_idx");

                entity.Property(e => e.Segid).HasColumnName("segid");

                entity.Property(e => e.Term).HasColumnName("term");

                entity.Property(e => e.Pgno).HasColumnName("pgno");
            });

            modelBuilder.Entity<AnnotationsFtsStemmed>(entity =>
            {
                entity.HasNoKey();

                entity.ToTable("annotations_fts_stemmed");

                entity.Property(e => e.SearchableText).HasColumnName("searchable_text");
            });

            modelBuilder.Entity<AnnotationsFtsStemmedConfig>(entity =>
            {
                entity.HasKey(e => e.K);

                entity.ToTable("annotations_fts_stemmed_config");

                entity.Property(e => e.K).HasColumnName("k");

                entity.Property(e => e.V).HasColumnName("v");
            });

            modelBuilder.Entity<AnnotationsFtsStemmedDatum>(entity =>
            {
                entity.ToTable("annotations_fts_stemmed_data");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Block).HasColumnName("block");
            });

            modelBuilder.Entity<AnnotationsFtsStemmedDocsize>(entity =>
            {
                entity.ToTable("annotations_fts_stemmed_docsize");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Sz).HasColumnName("sz");
            });

            modelBuilder.Entity<AnnotationsFtsStemmedIdx>(entity =>
            {
                entity.HasKey(e => new { e.Segid, e.Term });

                entity.ToTable("annotations_fts_stemmed_idx");

                entity.Property(e => e.Segid).HasColumnName("segid");

                entity.Property(e => e.Term).HasColumnName("term");

                entity.Property(e => e.Pgno).HasColumnName("pgno");
            });

            modelBuilder.Entity<Author>(entity =>
            {
                entity.ToTable("authors");

                entity.HasIndex(e => e.Name, "IX_authors_name")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Link)
                    .IsRequired()
                    .HasColumnName("link")
                    .HasDefaultValueSql("\"\"");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");

                entity.Property(e => e.Sort).HasColumnName("sort");
            });

            modelBuilder.Entity<Book>(entity =>
            {
                entity.ToTable("books");

                entity.HasIndex(e => e.AuthorSort, "authors_idx");

                entity.HasIndex(e => e.Sort, "books_idx");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.AuthorSort).HasColumnName("author_sort");

                entity.Property(e => e.Flags)
                    .HasColumnName("flags")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.HasCover)
                    .HasColumnType("BOOL")
                    .HasColumnName("has_cover")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Isbn)
                    .HasColumnName("isbn")
                    .HasDefaultValueSql("\"\"");

                entity.Property(e => e.LastModified)
                    .IsRequired()
                    .HasColumnType("TIMESTAMP")
                    .HasColumnName("last_modified")
                    .HasDefaultValueSql("\"2000-01-01 00:00:00+00:00\"");

                entity.Property(e => e.Lccn)
                    .HasColumnName("lccn")
                    .HasDefaultValueSql("\"\"");

                entity.Property(e => e.Path)
                    .IsRequired()
                    .HasColumnName("path")
                    .HasDefaultValueSql("\"\"");

                entity.Property(e => e.Pubdate)
                    .HasColumnType("TIMESTAMP")
                    .HasColumnName("pubdate")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.SeriesIndex)
                    .HasColumnName("series_index")
                    .HasDefaultValueSql("1.0");

                entity.Property(e => e.Sort).HasColumnName("sort");

                entity.Property(e => e.Timestamp)
                    .HasColumnType("TIMESTAMP")
                    .HasColumnName("timestamp")
                    .HasDefaultValueSql("CURRENT_TIMESTAMP");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title")
                    .HasDefaultValueSql("'Unknown'");

                entity.Property(e => e.Uuid).HasColumnName("uuid");
            });

            modelBuilder.Entity<BooksAuthorsLink>(entity =>
            {
                BooksAuthorsLink.EfSetup(entity);
            });

            modelBuilder.Entity<BooksLanguagesLink>(entity =>
            {
                BooksLanguagesLink.EfSetup(entity);                
            });

            modelBuilder.Entity<BooksPluginDatum>(entity =>
            {
                entity.ToTable("books_plugin_data");

                entity.HasIndex(e => new { e.Book, e.Name }, "IX_books_plugin_data_book_name")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");

                entity.Property(e => e.Val)
                    .IsRequired()
                    .HasColumnName("val");
            });

            modelBuilder.Entity<BooksPublishersLink>(entity =>
            {
                entity.ToTable("books_publishers_link");

                entity.HasIndex(e => e.Book, "IX_books_publishers_link_book")
                    .IsUnique();

                entity.HasIndex(e => e.Publisher, "books_publishers_link_aidx");

                entity.HasIndex(e => e.Book, "books_publishers_link_bidx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Publisher).HasColumnName("publisher");
            });

            modelBuilder.Entity<BooksRatingsLink>(entity =>
            {
                entity.ToTable("books_ratings_link");

                entity.HasIndex(e => new { e.Book, e.Rating }, "IX_books_ratings_link_book_rating")
                    .IsUnique();

                entity.HasIndex(e => e.Rating, "books_ratings_link_aidx");

                entity.HasIndex(e => e.Book, "books_ratings_link_bidx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Rating).HasColumnName("rating");
            });

            modelBuilder.Entity<BooksSeriesLink>(entity =>
            {
                entity.ToTable("books_series_link");

                entity.HasIndex(e => e.Book, "IX_books_series_link_book")
                    .IsUnique();

                entity.HasIndex(e => e.Series, "books_series_link_aidx");

                entity.HasIndex(e => e.Book, "books_series_link_bidx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Series).HasColumnName("series");
            });

            modelBuilder.Entity<BooksTagsLink>(entity =>
            {
                BooksTagsLink.EfSetup(entity);
            });

            modelBuilder.Entity<Comment>(entity =>
            {
                entity.ToTable("comments");

                entity.HasIndex(e => e.Book, "IX_comments_book")
                    .IsUnique();

                entity.HasIndex(e => e.Book, "comments_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Text)
                    .IsRequired()
                    .HasColumnName("text");
            });

            modelBuilder.Entity<ConversionOption>(entity =>
            {
                entity.ToTable("conversion_options");

                entity.HasIndex(e => new { e.Format, e.Book }, "IX_conversion_options_format_book")
                    .IsUnique();

                entity.HasIndex(e => e.Format, "conversion_options_idx_a");

                entity.HasIndex(e => e.Book, "conversion_options_idx_b");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Data)
                    .IsRequired()
                    .HasColumnName("data");

                entity.Property(e => e.Format)
                    .IsRequired()
                    .HasColumnName("format");
            });

            modelBuilder.Entity<CustomColumn>(entity =>
            {
                entity.ToTable("custom_columns");

                entity.HasIndex(e => e.Label, "IX_custom_columns_label")
                    .IsUnique();

                entity.HasIndex(e => e.Label, "custom_columns_idx");

                entity.Property(e => e.Id).HasColumnName("id");

                entity.Property(e => e.Datatype)
                    .IsRequired()
                    .HasColumnName("datatype");

                entity.Property(e => e.Display)
                    .IsRequired()
                    .HasColumnName("display")
                    .HasDefaultValueSql("\"{}\"");

                entity.Property(e => e.Editable)
                    .IsRequired()
                    .HasColumnType("BOOL")
                    .HasColumnName("editable")
                    .HasDefaultValueSql("1");

                entity.Property(e => e.IsMultiple)
                    .IsRequired()
                    .HasColumnType("BOOL")
                    .HasColumnName("is_multiple")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Label)
                    .IsRequired()
                    .HasColumnName("label");

                entity.Property(e => e.MarkForDelete)
                    .IsRequired()
                    .HasColumnType("BOOL")
                    .HasColumnName("mark_for_delete")
                    .HasDefaultValueSql("0");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");

                entity.Property(e => e.Normalized)
                    .IsRequired()
                    .HasColumnType("BOOL")
                    .HasColumnName("normalized");
            });

            modelBuilder.Entity<Data>(entity =>
            {
                Data.EfSetup(entity);
            });

            modelBuilder.Entity<Feed>(entity =>
            {
                entity.ToTable("feeds");

                entity.HasIndex(e => e.Title, "IX_feeds_title")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Script)
                    .IsRequired()
                    .HasColumnName("script");

                entity.Property(e => e.Title)
                    .IsRequired()
                    .HasColumnName("title");
            });

            modelBuilder.Entity<Identifier>(entity =>
            {
                entity.ToTable("identifiers");

                entity.HasIndex(e => new { e.Book, e.Type }, "IX_identifiers_book_type")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Type)
                    .IsRequired()
                    .HasColumnName("type")
                    .HasDefaultValueSql("\"isbn\"");

                entity.Property(e => e.Val)
                    .IsRequired()
                    .HasColumnName("val");
            });

            modelBuilder.Entity<Language>(entity =>
            {
                entity.ToTable("languages");

                entity.HasIndex(e => e.LangCode, "IX_languages_lang_code")
                    .IsUnique();

                entity.HasIndex(e => e.LangCode, "languages_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.LangCode)
                    .IsRequired()
                    .HasColumnName("lang_code");
            });

            modelBuilder.Entity<LastReadPosition>(entity =>
            {
                entity.ToTable("last_read_positions");

                entity.HasIndex(e => new { e.User, e.Device, e.Book, e.Format }, "IX_last_read_positions_user_device_book_format")
                    .IsUnique();

                entity.HasIndex(e => e.Book, "lrp_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");

                entity.Property(e => e.Cfi)
                    .IsRequired()
                    .HasColumnName("cfi");

                entity.Property(e => e.Device)
                    .IsRequired()
                    .HasColumnName("device");

                entity.Property(e => e.Epoch).HasColumnName("epoch");

                entity.Property(e => e.Format)
                    .IsRequired()
                    .HasColumnName("format");

                entity.Property(e => e.PosFrac).HasColumnName("pos_frac");

                entity.Property(e => e.User)
                    .IsRequired()
                    .HasColumnName("user");
            });

            modelBuilder.Entity<LibraryId>(entity =>
            {
                entity.ToTable("library_id");

                entity.HasIndex(e => e.Uuid, "IX_library_id_uuid")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Uuid)
                    .IsRequired()
                    .HasColumnName("uuid");
            });

            modelBuilder.Entity<MetadataDirtied>(entity =>
            {
                entity.ToTable("metadata_dirtied");

                entity.HasIndex(e => e.Book, "IX_metadata_dirtied_book")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Book).HasColumnName("book");
            });

            modelBuilder.Entity<Preference>(entity =>
            {
                entity.ToTable("preferences");

                entity.HasIndex(e => e.Key, "IX_preferences_key")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Key)
                    .IsRequired()
                    .HasColumnName("key");

                entity.Property(e => e.Val)
                    .IsRequired()
                    .HasColumnName("val");
            });

            modelBuilder.Entity<Publisher>(entity =>
            {
                entity.ToTable("publishers");

                entity.HasIndex(e => e.Name, "IX_publishers_name")
                    .IsUnique();

                entity.HasIndex(e => e.Name, "publishers_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");

                entity.Property(e => e.Sort).HasColumnName("sort");
            });

            modelBuilder.Entity<Rating>(entity =>
            {
                entity.ToTable("ratings");

                entity.HasIndex(e => e.Rating1, "IX_ratings_rating")
                    .IsUnique();

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Rating1).HasColumnName("rating");
            });

            modelBuilder.Entity<Series>(entity =>
            {
                entity.ToTable("series");

                entity.HasIndex(e => e.Name, "IX_series_name")
                    .IsUnique();

                entity.HasIndex(e => e.Name, "series_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");

                entity.Property(e => e.Sort).HasColumnName("sort");
            });

            modelBuilder.Entity<Tag>(entity =>
            {
                entity.ToTable("tags");

                entity.HasIndex(e => e.Name, "IX_tags_name")
                    .IsUnique();

                entity.HasIndex(e => e.Name, "tags_idx");

                entity.Property(e => e.Id)
                    .ValueGeneratedNever()
                    .HasColumnName("id");

                entity.Property(e => e.Name)
                    .IsRequired()
                    .HasColumnName("name");
            });

            OnModelCreatingPartial(modelBuilder);
        }

        partial void OnModelCreatingPartial(ModelBuilder modelBuilder);

        private void SetupContext() 
        {
            if (AsNoTracking)
            {
                ChangeTracker.QueryTrackingBehavior = QueryTrackingBehavior.TrackAll;
            }
            else 
            {
                ChangeTracker.QueryTrackingBehavior = QueryTrackingBehavior.NoTracking;
            }            
        }

        #endregion
    }
}
