﻿using System;
using System.Collections.Generic;

#nullable disable

using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Metadata.Builders;

namespace Calibre.Model.Database.Entities
{
    public partial class BooksLanguagesLink
    {
        public long Id { get; set; }


        public long Book { get; set; }
        public virtual Book BookItem { get; set; }

        public long LangCode { get; set; }
        public virtual Language LangItem { get; set; }

        public long ItemOrder { get; set; }


        public override string ToString()
        {
            return LangItem?.LangCode;
        }


        internal static void EfSetup(
            EntityTypeBuilder<BooksLanguagesLink> entity
            )
        {
            entity.ToTable("books_languages_link");

            entity.HasIndex(e => new { e.Book, e.LangCode }, "IX_books_languages_link_book_lang_code")
                .IsUnique();

            entity.HasIndex(e => e.LangCode, "books_languages_link_aidx");

            entity.HasIndex(e => e.Book, "books_languages_link_bidx");

            entity.Property(e => e.Id)
                .ValueGeneratedNever()
                .HasColumnName("id");

            entity.Property(e => e.Book).HasColumnName("book");

            entity.Property(e => e.ItemOrder).HasColumnName("item_order");

            entity.Property(e => e.LangCode).HasColumnName("lang_code");

            entity
                .HasOne(e => e.BookItem)
                .WithMany(e => e.Languages)
                .HasForeignKey(e => e.Book);
            entity
                .HasOne(e => e.LangItem)
                .WithMany(e => e.Books)
                .HasForeignKey(e => e.LangCode);
        }
    }
}
