﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

using System.Text;

using Calibre.Model.Database.Entities;
using Calibre.Model.Domain.Entities;

namespace Calibre.App.BlazorUI.ViewModels
{
    public class BookViewModel
    {
        #region Props

        public BookWithLibraryContainer[] AllBooks { set; get; }
            = Array.Empty<BookWithLibraryContainer>();

        public BookWithLibraryContainer[] VisibleBooks { set; get; }
            = Array.Empty<BookWithLibraryContainer>();

        #region UI

        public string SearchInput { set; get; }
            = string.Empty;

        #endregion

        #endregion



        #region Render

        public string ToBase64(byte[] fileBytes)
        {
            var result = Convert.ToBase64String(fileBytes);
            return result;
        }

        private string RenderStringArrayToRows(IReadOnlyList<string> data)
        {
            if (data.Count == 0)
            {
                return string.Empty;
            }
            if (data.Count == 1)
            {
                return data[0];
            }

            StringBuilder buffer = new StringBuilder(data[0].Length * data.Count);
            foreach (var elem in data)
            {
                buffer.AppendLine(elem);
                //buffer.Append($"{elem}</br>");
            }
            buffer.Length = buffer.Length - 2;

            var result = buffer.ToString();
            return result;
        }

        public string RenderAutorRow(Book book)
        {
            var data = book
                .Autors
                .Select(e => e.AuthorItem.Name)
                .ToArray();

            var result = RenderStringArrayToRows(data);
            return result;
        }

        public string RenderTags(Book book)
        {                        
            var data = book
                .Tags
                .Select(e => e.TagItem.Name)
                .ToArray();

            var result = RenderStringArrayToRows(data);
            return result;
        }

        #endregion
    }
}
