﻿using System;
using System.Collections.Generic;

#nullable disable

namespace Calibre.Model.Database.Entities
{
    public partial class Author
    {
        public long Id { get; set; }
        public string Name { get; set; }
        public string Sort { get; set; }
        public string Link { get; set; }

        public virtual List<BooksAuthorsLink> Books { get; set; }
            = new List<BooksAuthorsLink>();


        #region

        public override int GetHashCode()
        {
            return Id.GetHashCode();
        }
        public override bool Equals(object obj)
        {
            if (obj is Tag tag)
            {
                return tag.Id == Id;
            }

            return false;
        }
        public override string ToString()
        {
            return $"{Id}|{Name}";
        }

        #endregion
    }
}
