﻿using System;

using Microsoft.EntityFrameworkCore;

using LibraryText.Entities;

namespace LibraryText
{
    public class ApplicationContext 
        : DbContext
    {
        public DbSet<BookTextData> Books { get; set; }


        public ApplicationContext()
            : base()
        {
            Database.EnsureCreated();   // создаем базу данных при первом обращении
        }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            optionsBuilder.UseSqlServer(@"Server=(localdb)\mssqllocaldb;Database=Books;Trusted_Connection=True;MultipleActiveResultSets=true");
        }
    }
}
