﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;
using System.Collections.Immutable;

using Calibre.Model.Database.Entities;

namespace Calibre.Model.Domain.Entities
{
    /// <summary>
    /// Immutable
    /// </summary>
    public class Library
    {
        #region Properties

        public string Name { private set; get; }
        public string FullName { private set; get; }

        public FileInfo DbFile => new FileInfo(
            Path.Combine(FullName, DbFileName)
            );

        public ImmutableDictionary<string, BookWithLibraryContainer> Books { private set; get; }
            = ImmutableDictionary<string, BookWithLibraryContainer>.Empty;

        #endregion


        private Library() { }



        #region override

        public override int GetHashCode()
        {
            return FullName.GetHashCode();
        }

        public override bool Equals(object obj)
        {
            if (obj is Library l)
            {
                return string.Equals(FullName, l.FullName);
            }

            return false;
        }

        public override string ToString()
        {
            return FullName;
        }

        #endregion


        #region static

        public static string DbFileName 
            => "metadata.db";

        public static Library[] SearchAll(DirectoryInfo directory) 
        {
            var dbFiles = directory
                .GetFiles(
                    DbFileName, 
                    SearchOption.AllDirectories
                    )
                .ToArray();

            var result = dbFiles.Select(
                e => new Library() 
                { 
                    FullName = e.Directory.FullName,
                    Name = e.Directory.Name
                })
                .ToArray();

            return result;
        }

        public static string BuildConnectionStringFromPath(
            string pathToDbFile
            )
        {
            return $"Filename={pathToDbFile}";
        }

        public static Library AddBookContainer(
            Library library,
            BookWithLibraryContainer bookContainer
            )
        {
            var result = new Library() 
            {
                Name = library.Name,
                FullName = library.FullName
            };

            result.Books = library.Books.Add(
                bookContainer.Book.Title, 
                bookContainer
                );

            return result;
        }

        public static string GetPdfFilePath(
            Library library, 
            Book book
            )
        {
            var file = book.FileData.First(
                e => string.Equals(e.Format, "PDF", StringComparison.OrdinalIgnoreCase)
                );

            var result = Path.Combine(
                library.FullName,
                book.Path.Replace('/', '\\'),
                $"{file.Name}.{file.Format}"
                );

            return result;
        }

        #endregion
    }
}
