﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

using Tools.PdfProvider;

using Calibre.Model.Database.Entities;

using LibraryClass = Calibre.Model.Domain.Entities.Library;

namespace Calibre.Model.Domain.Entities
{
    /// <summary>
    /// Immutable
    /// </summary>
    public class BookWithLibraryContainer
    {
        #region Properties

        public Book Book { private set; get; }
        public ImmutableProxy<LibraryClass> Library { private set; get; }

        #endregion


        private BookWithLibraryContainer() 
        {
            
        }


        #region methods
                
        public async Task ReadFileAsync(
            Func<Stream, Task> readActionAsync
            )
        {
            var filePath = LibraryClass.GetPdfFilePath(Library.Data, Book);
            using (var stream = new FileStream(filePath, FileMode.Open))
            {
                await readActionAsync(stream);
            }
        }

        public async Task<T> ReadFileAsync<T>(
            Func<Stream, Task<T>> readActionAsync
            ) 
        {
            var filePath = LibraryClass.GetPdfFilePath(Library.Data, Book);
            using (var stream = new FileStream(filePath, FileMode.Open))
            {
                var result = await readActionAsync(stream);
                return result;
            }
        }

        #endregion


        #region override

        public override int GetHashCode()
        {
            return Book.GetHashCode();
        }

        public override string ToString()
        {
            return Book.ToString();
        }

        #endregion


        #region static

        public static BookWithLibraryContainer Create(
            Book book, 
            ImmutableProxy<LibraryClass> library
            )
        {            
            var item = new BookWithLibraryContainer() 
            {
                Book = book,
                Library = library
            };

            library.MutateValue(
                e => LibraryClass.AddBookContainer(library.Data, item)
                );

            return item;
        }

        #endregion
    }
}
